-- # kyttohjeet:
-- # hammer
-- #  + luo hammeri ja aseta se layerille
-- #  + aseta translation eli maailman koordinaatit miss sylinteri on
-- #  + luodaan triggeri ja asetaan se
-- #  + asetetaan idleparit
-- #    + kauanko idletn ylhll ennenkuin aloitetaan siirtymn alas
-- #    + kauanko idletn alhaalla ennenkuin aloitetaan siirtymn yls
-- #    + jrjestys AINA: idle_ylhll - idle_alhaalla
-- #  + asetetaan nopeusparit
-- #    + kuinka nopeasti lydn alas
-- #    + kuinka nopeasti noustaan yls
-- #    + jrjestys AINA: nopeus_alaspin - nopeus_ylspin
-- #  + asetetaan "tern" / "mnnn" ptepisteet
-- #    + x1, y1, x2, y2
-- #      + eli transformista x1,y1 pisteeseen tulee aloitus piste eli mist mnt lhtee liikkeelle ( jos 0.0f, 0.0f niin lhtee sylinterin keskelt )
-- #      + x2,y2 = mihin mnt lopett matkanteon ( jos 0.0f, -100.0f niin pyshtyy 100 pykl transformin alapuolelle )
-- #    + mahdollista laittaa hakkaamaan esim vaakatasoon jolloin voidaan laittaa esim sein joka siirt pelaajan joltain maatilkulta pois
-- #  + asetetaan animaation sylinterille
-- #  + asetetaan animaation mnnlle eli terlle
-- #  + asetetaan halutessa kulma poikkeama terlle ( 0.0f vakiona eli Math::half_pi() -> ter on kokoajan 90asteen kulmassa varteen nhen )
-- #  + asetetaan kuva varrelle
-- #    + periaatteessa ketjun lenkki -> koodi laittaa sen menemn vlille vaikka 10000 kertaa jos osa on niin pieni
-- #
-- #  + luo liikkumis ni hammerille seuraavalla tavalla, ei pakollinen
-- #  + luo soundi ( flying sound )
-- #  + converttaa siit SoundEffect
-- #  + aseta se hammerille
-- #
-- #  + TARKISTA ETT TRIGGERI KULKEE SAMAA MATKAA KUVAN KANSSA (jos eri layerill vaikuttaa)
-- #
-- # shooter
-- # + luo shooter ja aseta se layerille
-- # + aseta idle ajat shootterille
-- #   + muista syist pit asettaa pareittain eli jos haluaa vain 1 idle ajan niin pit laittaa 2 samaa
-- #   + parittomat ajat pit kikkailla , eli laittaa vaikka 2 kertaa samat -> parittomasta tulee parillinen
-- # + luo shootterille idle animaatio
-- # + aseta idle animaatio shootterille
-- #
-- # + luo shooting effect (sound)
-- # + aseta shooting effect (sound) shooterille
-- #
-- # + luo bullet
-- # + luo remorfable sprite
-- #   + remorfablen alotus coordinaatti          = mist ammus lhtee lentoon
-- #   + remorfablen viimesen framen coordinaatit = miss ammus rjht
-- # + luo gatetrigger
-- # + aseta molemmat bulletille
-- #
-- # + luo lentoni ammukselle seuraavalla tavallla, ei pakollinen
-- # + luo soundi ( flying sound )
-- # + converttaa siit SoundEffect
-- # + aseta se bulletille
-- #
-- # + aseta bullet shootterille
-- # + TARKISTA ETT TRIGGERI KULKEE SAMAA MATKAA KUVAN KANSSA (jos eri layerill vaikuttaa)


--Pendulum starts
--hammer starts
local hammer_1_id = 10001;
local hammer_target_layer = 5;
local hammer_x = 900.0;
local hammer_y = 200.0;
lua:create_hammer(           hammer_1_id, hammer_x, hammer_y, hammer_target_layer)                  -- id , cylinder x , cylinder y

--shape & trigger
local hammer_1_circle = "hammer_1_shape";
local hammer_1_trigger = "hammer_1_trigger";
lua:create_circle(  hammer_1_circle,   0.0, 0.0, 50.0)                                              --name, x, y, radius
lua:create_trigger( hammer_1_trigger,  TT_GATE, "data/scripts/srt_game_over.lua","", 0.0, 0.0)      --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape(  hammer_1_trigger,  TT_GATE, hammer_1_circle)                                    --name, type, shape_name
lua:trigger_add_group_can_use_me(hammer_1_trigger,  TT_GATE, "player")                              --name, type, group_name
lua:trigger_add_group_i_belong_to(hammer_1_trigger, TT_GATE, "killer")                              --name, type, group_name

lua:hammer_add_trigger(      hammer_1_id, hammer_1_trigger)                                         -- id, trigger

--idle pairs
lua:hammer_add_idle_pair(    hammer_1_id, 5.0, 1.0)                         -- id, idle up before moving out, idle down before moving in
lua:hammer_add_idle_pair(    hammer_1_id, 1.0, 1.0)                         -- id, idle up before moving out, idle down before moving in

--speed pairs
lua:hammer_add_speed_pair(   hammer_1_id, 500.0, 100.0)                     -- id, speed away from cylinder, speed towards cylinder
lua:hammer_add_speed_pair(   hammer_1_id, 100.0, 100.0)                     -- id, speed away from cylinder, speed towards cylinder

--start and end locations
lua:hammer_piston_locations( hammer_1_id, -100.0, -200.0, 300.0, 100.0)     -- id, startpoint x, startpoint y, endpoint x, endpoint y

--create animated sprite, but will not place it to layer
local hammer_cylinder_sprite   = "hammer_cylinder_sprite";
local hammer_piston_sprite     = "hammer_piston_sprite";
local hammer_crankshaft_sprite = "hammer_crankshaft_sprite";

lua_init_texture_animation(     hammer_cylinder_sprite, "data/images/characters/vampire/idle/", 20, MODE_LOOP, DIRECTION_FORWARD, 0.3, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:create_sprite(              hammer_cylinder_sprite,  ST_ANIMATED, hammer_cylinder_sprite,  0.0,  0.0)                            --  sprite name, animated or not, animation name, translation x, y
lua:sprite_shape(               hammer_cylinder_sprite,  ST_ANIMATED,                         80.0, 50.0)                            --  sprite name, animated or not, half width, half height

lua_init_texture_animation(     hammer_piston_sprite,  "data/images/characters/vampire/run/",   13, MODE_LOOP, DIRECTION_FORWARD, 0.17, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:create_sprite(              hammer_piston_sprite,  ST_ANIMATED, hammer_piston_sprite,    0.0,  0.0)                              --  sprite name, animated or not, animation name, translation x, y
lua:sprite_shape(               hammer_piston_sprite,  ST_ANIMATED,                         20.0, 50.0)                              --  sprite name, animated or not, half width, half height

lua_init_texture(               hammer_crankshaft_sprite, "data/images/lantern.png", FM_NEAREST, WM_REPEAT, WM_REPEAT, AM_MODULATE)  -- !! HAVE TO BE REPEAT !!
lua:create_sprite(              hammer_crankshaft_sprite, ST_TEXTURED,    hammer_crankshaft_sprite, 0.0, 0.0)                        --  sprite name, animated or not, animation name, translation x, y
lua:sprite_shape(               hammer_crankshaft_sprite, ST_TEXTURED,    20.0,   10.0)                                              --  sprite name, animated or not, half width, half height
lua:textured_sprite_tex_coords( hammer_crankshaft_sprite, ST_TEXTURED,     0.0,    0.0, 1.0, 1.0)                                    --  code will override this basically

--set sprite to hammer, will NOT remove it from temporary list
lua:hammer_set_cylinder_animatedsprite(  hammer_1_id, hammer_cylinder_sprite   )  -- id, animation name
lua:hammer_set_piston_animatedsprite(    hammer_1_id, hammer_piston_sprite     )  -- id, animation name
lua:hammer_set_piston_angledifference(   hammer_1_id, 0.45*0.5*3.14            )  -- id, angle(rads)      -- 0.45f * Math::half_pi() -- half_pi = 90degrees
lua:hammer_set_crankshaft_sprite(        hammer_1_id, hammer_crankshaft_sprite )  -- id, animation name

--remove from temp list
lua:gameobject_remove_from_temp_list( hammer_cylinder_sprite   )
lua:gameobject_remove_from_temp_list( hammer_piston_sprite     )
lua:gameobject_remove_from_temp_list( hammer_crankshaft_sprite )

--hammer audio
local hammer_down_sound =  "hammer_down_sound";
local hammer_up_sound   =  "hammer_up_sound";
lua:create_sound(hammer_down_sound, "data/music/effect_stereo.ogg",  500.0, hammer_x, hammer_y)   -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
lua:create_sound(hammer_up_sound, "data/music/effect_stereo.ogg",    500.0, hammer_x, hammer_y)   -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )

lua:create_sound_effect(hammer_down_sound, hammer_down_sound, 0.1, true)                         -- object name, sound name, delay, loop
lua:create_sound_effect(hammer_up_sound, hammer_up_sound, 0.1, true)                             -- object name, sound name, delay, loop

lua:hammer_add_down_going_sound(hammer_1_id, hammer_down_sound)                                  -- hammer id, flying sound
lua:hammer_add_down_going_sound(hammer_1_id, hammer_up_sound)                                    -- hammer id, flying sound

lua:gameobject_remove_from_temp_list( hammer_down_sound )
lua:gameobject_remove_from_temp_list( hammer_up_sound )
--hammer ends

















--shooter starts
local shooter_id = 10012; 
local bullet_id  = 12345;

local shooter_x =  900.0
local shooter_y = -100.0
local shooter_target_layer = 5;
lua:create_shooter( shooter_id, shooter_x, shooter_y , shooter_target_layer);                  -- id, local origin x, y

--lua:shooter_set_idle_time(  shooter_id, 2.0, 0.5 );        -- id, time 1, time 2
--lua:shooter_set_idle_time(  shooter_id, 0.1, 0.5 );        -- id, time 3, time 4

--for sound testing
lua:shooter_set_idle_time(    shooter_id, 4.0, 4.0 );

local shooter_idle_animation = "shooter_idle_animation";
lua_init_texture_animation(     shooter_idle_animation,  "data/images/characters/vampire/run/",   13, MODE_LOOP, DIRECTION_FORWARD, 0.17, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:create_sprite(              shooter_idle_animation,  ST_ANIMATED, hammer_piston_sprite,    0.0,  0.0)   -- sprite name, animated or not, animation name, translation x, y
lua:sprite_shape(               shooter_idle_animation,  ST_ANIMATED,                         40.0, 20.0)   -- name, type, width, height

lua:shooter_set_idle_animation( shooter_id, shooter_idle_animation );

-- create sound for shooting effect
local shooter_shoot_sound = "shooter_shoot_sound";
lua:create_sound(shooter_shoot_sound, "data/music/effect_stereo.ogg", 250.0, shooter_x, shooter_y)  -- name, music_name, radius, x,y
lua:shooter_add_shooting_effect(shooter_id, shooter_shoot_sound)                                    -- shooter id, sound name
lua:remove_sound_from_sounds_temp(shooter_shoot_sound)                                              -- sound name
--shooter ends

















--bullet starts
local target_layer = 4;
local bullet_sprite = "bullet_sprite";
local bullet_shape = "bullet_shape";
local bullet_trigger = "bullet_trigger";
local is_repeat = false

lua:create_bullet( shooter_id, bullet_id );            -- shooter id, bullet id -- lets just create bullet to our shooter, little stupid but anyway
--trigger
lua:create_shape( bullet_shape, 1, 5, 0 );         -- shape with, 1 = shape with number of verticies, 5 = number of verticies
lua:shape_vertex( bullet_shape, 0, -20.0 , -20.0 ) -- name, vertex number, x, y
lua:shape_vertex( bullet_shape, 1,   0.0 , -30.0 ) -- name, vertex number, x, y
lua:shape_vertex( bullet_shape, 2,  20.0 , -20.0 ) -- name, vertex number, x, y
lua:shape_vertex( bullet_shape, 3,  20.0 ,  20.0 ) -- name, vertex number, x, y
lua:shape_vertex( bullet_shape, 4, -20.0 ,  20.0 ) -- name, vertex number, x, y

lua:create_trigger( bullet_trigger, TT_GATE, "","", shooter_x,shooter_y)  --name, type, on_enter_script, on_leave_scipt,x,y  -- x and y should be very close to real start location
lua:trigger_shape(  bullet_trigger, TT_GATE, bullet_shape)                --name, type, shape_name
lua:trigger_add_group_i_belong_to( bullet_trigger, TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me(  bullet_trigger, TT_GATE, "player")     --name, type, group_name

lua:trigger_set_color(  bullet_trigger, 0.5, 0.5, 0.5, 0.3);              --trigger name, red, green, blue, alpha
lua:bullet_set_trigger( shooter_id, bullet_trigger );                     --shooter id, trigger name

--graphics
lua_init_texture("lantern", "data/images/lantern.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)

-- start coordinates , end coordinates are on last frame
local bullet_start_x = shooter_x-50.0;
local bullet_start_y = shooter_y+50.0;

lua:create_sprite("lanterm", ST_TEXTURED,"lantern", bullet_start_x, bullet_start_y)          -- name, textured, name, x, y
lua:sprite_shape("lanterm",ST_TEXTURED,16.0, 32.0)
lua:textured_sprite_tex_coords("lanterm", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)
lua:remorfable_sprite(bullet_sprite, "lanterm", 0.1, false)                        -- name, sprite_name, speed, repeat

lua:add_key_frame(0.99999999, bullet_start_x-500, bullet_start_y, 0.5, 0.5)        -- adds a new key frame. time, x, y, rotation, scale
lua:add_key_frame_color(1.0,1.0,1.0,0.25)                                          -- r,g,b,a
lua:upload_key_frame(bullet_sprite)

lua:bullet_set_graphics(shooter_id, bullet_sprite, target_layer)                   -- shooter id, sprite, bullet target layer
lua:gameobject_remove_from_temp_list( bullet_sprite )

-- audio
local bullet_flying_sound = "bullet_flying_sound";

lua:create_sound(bullet_flying_sound, "data/music/effect_stereo.ogg",  50.0, bullet_start_x, bullet_start_y)  -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
lua:create_sound_effect(bullet_flying_sound, bullet_flying_sound, 0.1, true)                                  -- object name, sound name, delay, loop
lua:bullet_set_flying_sound(shooter_id, bullet_flying_sound)                                                  -- shooter id, flying sound
lua:gameobject_remove_from_temp_list( bullet_flying_sound )

--bullet ends
--Pendulum ends